﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class RegistryMaster : System.Web.UI.MasterPage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    
    public event MasterPageMenuClickHandler MenuClick;

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html");
    }
    
    protected void Page_Load(object sender, EventArgs e)
    {
        //Sets the correct URL for context sensitive help, based on content page
        HyperLinkHelp.NavigateUrl = GetContextSensitiveHelpURL();
        
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;

        if (Convert.ToBoolean(Helpers.GetConfigEntry("DisplayUser")) == true)
        {
            lblCurrentDateTime.Text =  DateTime.Now.ToString();
            lblCurrentUser.Text = user.FullName;
            lblRole.Text = user.RoleName;
            Label1.Visible = true;
            Label2.Visible = true;
            lblCurrentDateTime.Visible = true;
            lblCurrentUser.Visible = true;
            lblRole.Visible = true;
        }

        //Set onfocus event to all apropriate controls on the page.
        if (!IsPostBack)
            HookOnFocus(this.Page as Control);

        SetMyTasksLink();
        Page.Header.DataBind();

        if (Page.Page.ToString() != "ASP.labresultsinterpretationletters_aspx"
            && Session["PrintCompletedLetters"] != null)
        {
          Helpers.RemoveAllLettersFromPrintQueue();
        }
    }

    /// <summary>
    /// This function sets HyperLinkMyTasks.NavigateUrl 
    /// based on the user role.
    /// </summary>
    private void SetMyTasksLink()
    {
        if ( _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR)
                || _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_NURSE)
                || _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_PROVIDER))
        {
            HyperLinkMyTasks.NavigateUrl = "Referrals.aspx";
        }
        else if (_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_ADMINISTRATOR))
        {
            HyperLinkMyTasks.NavigateUrl = "LabKitOrders.aspx";
        }
        else if (_user.GetRoles().Contains((int)RoleCode.EFR_DATA_ENTRY_PERSONNEL))
        {
            HyperLinkMyTasks.NavigateUrl = "Surveys.aspx?statusId=6";
        }
    }

    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="CurrentControl">the control to hook.</param>
    private void HookOnFocus(Control CurrentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((CurrentControl is TextBox) ||
            (CurrentControl is DropDownList) ||
            (CurrentControl is ListBox) ||
            (CurrentControl is CheckBoxList) ||
            (CurrentControl is RadioButton) ||
            (CurrentControl is Button))

            if (CurrentControl != null)
            {
                WebControl cntrl = CurrentControl as WebControl;
                if (cntrl != null)
                {
                    cntrl.Attributes.Add(
                  "onfocus",
                  "try{document.getElementById('__LASTFOCUS').value=this.id} catch(e) {}"
                        );

                }
            }
           
           

        //checks if the control has children
        if (CurrentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in CurrentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }


    public void SetDirtyFlag(bool flag)
    {

        dirtyFlag.Value = flag == true ? "1" : "0" ;


    }

}
